<?php
// This script provides a simple landing page with buttons for each document type.
// Clicking a button directs the user to a dedicated file (e.g., expense.php) for form filling.

$templates = [
    'Company Letterpad'     		=> 'company_letterpad.php',
    'Salary Certificate'    		=> 'salary_certificate.php',
    'Pay Slip'                    	=> 'pay_slip.php',
    'Leave Application'     		=> 'leave_application.php',
    'Completion Certificate' 		=> 'completion_certificate.php',
    'Offer Letter'          		=> 'offer_letter.php',
    'Contractual Agreement'         => 'contractual_agreement.php',
    'Invoice'               		=> 'invoice.php',
    'Expense List'               	=> 'expense.php', 
    'SLA Template' 					=> 'sla.php',
    'Convey Expense List'        	=> 'convey_expense.php',
];
?>

<style>
    .template-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 20px;
        margin-top: 20px;
    }
    .template-button {
        display: block;
        padding: 20px;
        background-color: #3498db;
        color: white;
        text-align: center;
        text-decoration: none;
        border-radius: 8px;
        font-size: 1.1em;
        font-weight: bold;
        transition: background-color 0.3s, transform 0.1s;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        border: none;
        cursor: pointer;
    }
    .template-button:hover {
        background-color: #2980b9;
        transform: translateY(-2px);
    }
</style>

<div class="form-card">
    <h3>Document Creation Center</h3>
    <p>Select a document type below to open the dedicated form and generate the final document.</p>
    
    <div class="template-grid">
        <?php foreach ($templates as $title => $file): ?>
            <a href="admin_dashboard.php?page=<?php echo str_replace('.php', '', $file); ?>" class="template-button">
                Create a <?php echo htmlspecialchars($title); ?>
            </a>
        <?php endforeach; ?>
    </div>
</div>
