<?php
// Start the session to access session variables
session_start();

// 1. Clear all session variables
$_SESSION = array();

// 2. Destroy the session itself
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}
session_destroy();

// --- Immediate Redirection to Login Page ---

// Redirect to the login page (index.php) and include a status parameter.
// The index.php page must be updated to check for this 'status' parameter
// and display the success message accordingly.
$redirect_url = 'index.php?status=logged_out';

// Perform the immediate redirect
header("Location: " . $redirect_url);
exit;

// The rest of the file (HTML/CSS) is no longer needed as the redirect is immediate.
?>
